/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.options;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.Prefs;
import com.megacrit.cardcrawl.helpers.SaveHelper;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.screens.options.AbandonRunButton;
import com.megacrit.cardcrawl.screens.options.Dropdown;
import com.megacrit.cardcrawl.screens.options.ExitGameButton;
import com.megacrit.cardcrawl.screens.options.Slider;
import com.megacrit.cardcrawl.screens.options.ToggleButton;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveAndContinue;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public class OptionsPanel {
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Options Tip");
    public static final String[] MSG = OptionsPanel.tutorialStrings.TEXT;
    public static final String[] LABEL = OptionsPanel.tutorialStrings.LABEL;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("OptionsPanel");
    public static final String[] TEXT = OptionsPanel.uiStrings.TEXT;
    private static final int RAW_W = 1364;
    private static final int RAW_H = 752;
    private static final int BANNER_W = 600;
    private static final int BANNER_H = 130;
    private AbandonRunButton abandonBtn;
    private ExitGameButton exitBtn;
    public Dropdown resoDropdown;
    public Dropdown fpsDropdown;
    public static Prefs soundPref = SaveHelper.getPrefs("STSSound");
    private Slider masterSlider;
    private Slider bgmSlider;
    private Slider sfxSlider;
    public static Prefs gamePref = SaveHelper.getPrefs("STSGameplaySettings");
    private static final float TOGGLE_X_LEFT = 430.0f * Settings.scale;
    private static final float TOGGLE_X_LEFT_2 = 660.0f * Settings.scale;
    private static final float TOGGLE_X_RIGHT = 1030.0f * Settings.scale;
    public ToggleButton fsToggle;
    public ToggleButton wfsToggle;
    public ToggleButton vSyncToggle;
    private ToggleButton ssToggle;
    private ToggleButton ambienceToggle;
    private ToggleButton sumToggle;
    private ToggleButton blockToggle;
    private ToggleButton confirmToggle;
    private ToggleButton commonToggle;
    private ToggleButton cardToggle;
    private ToggleButton powerToggle;
    private ToggleButton relicToggle;
    private ToggleButton uploadToggle;
    private ToggleButton playtesterToggle;
    private Hitbox uploadQuestionHb = new Hitbox(32.0f, 32.0f);
    private Dropdown languageDropdown;
    public ArrayList<AbstractGameEffect> effects = new ArrayList();

    public OptionsPanel() {
        this.fsToggle = new ToggleButton(TOGGLE_X_LEFT, 98.0f, ToggleButton.ToggleBtnType.FULL_SCREEN);
        this.wfsToggle = new ToggleButton(TOGGLE_X_LEFT, 64.0f, ToggleButton.ToggleBtnType.W_FULL_SCREEN);
        this.ssToggle = new ToggleButton(TOGGLE_X_LEFT, 30.0f, ToggleButton.ToggleBtnType.SCREEN_SHAKE);
        this.vSyncToggle = new ToggleButton(TOGGLE_X_LEFT_2, 30.0f, ToggleButton.ToggleBtnType.V_SYNC);
        this.sumToggle = new ToggleButton(TOGGLE_X_LEFT, -122.0f, ToggleButton.ToggleBtnType.SUM_DMG);
        this.blockToggle = new ToggleButton(TOGGLE_X_LEFT, -156.0f, ToggleButton.ToggleBtnType.BLOCK_DMG);
        this.confirmToggle = new ToggleButton(TOGGLE_X_LEFT, -190.0f, ToggleButton.ToggleBtnType.HAND_CONF);
        this.commonToggle = new ToggleButton(TOGGLE_X_LEFT, -254.0f, ToggleButton.ToggleBtnType.COMMON_TIP);
        this.cardToggle = new ToggleButton(TOGGLE_X_LEFT, -288.0f, ToggleButton.ToggleBtnType.CARD_TIP);
        this.powerToggle = new ToggleButton(TOGGLE_X_LEFT_2, -254.0f, ToggleButton.ToggleBtnType.POWER_TIP);
        this.relicToggle = new ToggleButton(TOGGLE_X_LEFT_2, -288.0f, ToggleButton.ToggleBtnType.RELIC_TIP);
        this.ambienceToggle = new ToggleButton(TOGGLE_X_RIGHT, 34.0f, ToggleButton.ToggleBtnType.AMBIENCE_ON);
        if (Settings.isBeta) {
            this.playtesterToggle = new ToggleButton(TOGGLE_X_RIGHT, -220.0f, ToggleButton.ToggleBtnType.PLAYTESTER_ART);
        }
        this.uploadToggle = new ToggleButton(TOGGLE_X_RIGHT, -254.0f, ToggleButton.ToggleBtnType.UPLOAD_DATA);
        this.uploadQuestionHb.move(TOGGLE_X_RIGHT + 254.0f * Settings.scale, Settings.OPTION_Y - 254.0f * Settings.scale);
        this.masterSlider = new Slider(Settings.OPTION_Y + 186.0f * Settings.scale, Settings.MASTER_VOLUME, Slider.SliderType.MASTER);
        this.bgmSlider = new Slider(Settings.OPTION_Y + 142.0f * Settings.scale, Settings.MUSIC_VOLUME, Slider.SliderType.BGM);
        this.sfxSlider = new Slider(Settings.OPTION_Y + 98.0f * Settings.scale, Settings.SOUND_VOLUME, Slider.SliderType.SFX);
        this.resoDropdown = new Dropdown(670.0f * Settings.scale, 186.0f, Dropdown.DropdownType.RESOLUTION);
        this.fpsDropdown = new Dropdown(670.0f * Settings.scale, 150.0f, Dropdown.DropdownType.FPS);
        this.languageDropdown = new Dropdown(1250.0f * Settings.scale, -158.0f, Dropdown.DropdownType.LANGUAGE);
        this.exitBtn = new ExitGameButton();
        this.abandonBtn = new AbandonRunButton();
    }

    public void update() {
        if (CardCrawlGame.mode == CardCrawlGame.GameMode.GAMEPLAY && AbstractDungeon.player != null && !AbstractDungeon.player.isDead) {
            this.abandonBtn.update();
        }
        this.exitBtn.update();
        this.updateEffects();
        this.updateGraphics();
        this.updateSound();
        this.updatePreferences();
        this.updateMiscellaneous();
    }

    private void updateEffects() {
        Iterator<AbstractGameEffect> c = this.effects.iterator();
        while (c.hasNext()) {
            AbstractGameEffect e = c.next();
            e.update();
            if (!e.isDone) continue;
            c.remove();
        }
    }

    private void updateGraphics() {
        this.fsToggle.update();
        this.wfsToggle.update();
        this.ssToggle.update();
        this.vSyncToggle.update();
        this.resoDropdown.update();
        this.fpsDropdown.update();
        if (this.fsToggle.hb.hovered) {
            TipHelper.renderGenericTip((float)InputHelper.mX + 70.0f * Settings.scale, (float)InputHelper.mY + 50.0f * Settings.scale, LABEL[1], MSG[1]);
        } else if (this.wfsToggle.hb.hovered) {
            TipHelper.renderGenericTip((float)InputHelper.mX + 70.0f * Settings.scale, (float)InputHelper.mY + 50.0f * Settings.scale, LABEL[2], MSG[2]);
        } else if (this.fpsDropdown.hb.hovered) {
            TipHelper.renderGenericTip((float)InputHelper.mX + 70.0f * Settings.scale, (float)InputHelper.mY + 50.0f * Settings.scale, LABEL[3], MSG[3]);
        }
    }

    private void updateSound() {
        this.ambienceToggle.update();
        this.masterSlider.update();
        this.bgmSlider.update();
        this.sfxSlider.update();
    }

    private void updatePreferences() {
        this.sumToggle.update();
        this.blockToggle.update();
        this.confirmToggle.update();
        this.commonToggle.update();
        this.cardToggle.update();
        this.powerToggle.update();
        this.relicToggle.update();
    }

    private void updateMiscellaneous() {
        this.uploadToggle.update();
        this.uploadQuestionHb.update();
        if (Settings.isBeta) {
            this.playtesterToggle.update();
        }
        if (this.uploadQuestionHb.hovered) {
            TipHelper.renderGenericTip((float)InputHelper.mX + 70.0f * Settings.scale, (float)InputHelper.mY + 50.0f * Settings.scale, LABEL[0], MSG[0]);
        }
        this.languageDropdown.update();
    }

    public void render(SpriteBatch sb) {
        this.renderBg(sb);
        this.renderBanner(sb);
        this.renderGraphics(sb);
        this.renderSound(sb);
        this.renderPreferences(sb);
        this.renderMiscellaneous(sb);
        if (CardCrawlGame.mode == CardCrawlGame.GameMode.GAMEPLAY && AbstractDungeon.player != null && !AbstractDungeon.player.isDead) {
            this.abandonBtn.render(sb);
        }
        this.exitBtn.render(sb);
        for (AbstractGameEffect e : this.effects) {
            e.render(sb);
        }
    }

    private void renderBg(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(ImageMaster.OPTION_PANE, (float)Settings.WIDTH / 2.0f - 682.0f, Settings.OPTION_Y - 376.0f, 682.0f, 376.0f, 1364.0f, 752.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1364, 752, false, false);
    }

    private void renderBanner(SpriteBatch sb) {
        sb.draw(ImageMaster.OPTION_BANNER, 568.0f * Settings.scale - 300.0f, Settings.OPTION_Y + 350.0f * Settings.scale - 65.0f, 300.0f, 65.0f, 600.0f, 130.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 600, 130, false, false);
        FontHelper.renderFontCenteredWidth(sb, FontHelper.menuBannerFont, TEXT[1], 430.0f * Settings.scale, Settings.OPTION_Y + 376.0f * Settings.scale, Color.DARK_GRAY);
    }

    private void renderGraphics(SpriteBatch sb) {
        FontHelper.renderFontCentered(sb, FontHelper.deckBannerFont, TEXT[2], 636.0f * Settings.scale, Settings.OPTION_Y + 250.0f * Settings.scale, Settings.GOLD_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.rewardTipFont, TEXT[3], 410.0f * Settings.scale, Settings.OPTION_Y + 196.0f * Settings.scale, 10000.0f, 36.0f * Settings.scale, Settings.CREAM_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[4], 456.0f * Settings.scale, Settings.OPTION_Y + 106.0f * Settings.scale, 10000.0f, 34.0f * Settings.scale, Settings.CREAM_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[17], 686.0f * Settings.scale, Settings.OPTION_Y + 106.0f * Settings.scale, 10000.0f, 34.0f * Settings.scale, Settings.CREAM_COLOR);
        this.fsToggle.render(sb);
        this.wfsToggle.render(sb);
        this.ssToggle.render(sb);
        this.vSyncToggle.render(sb);
        this.resoDropdown.render(sb);
        this.fpsDropdown.render(sb);
    }

    private void renderSound(SpriteBatch sb) {
        FontHelper.renderFontCentered(sb, FontHelper.deckBannerFont, TEXT[5], 1264.0f * Settings.scale, Settings.OPTION_Y + 250.0f * Settings.scale, Settings.GOLD_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.rewardTipFont, TEXT[6], 1020.0f * Settings.scale, Settings.OPTION_Y + 196.0f * Settings.scale, 10000.0f, 44.0f * Settings.scale, Settings.CREAM_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[7], 1056.0f * Settings.scale, Settings.OPTION_Y + 42.0f * Settings.scale, 10000.0f, 44.0f * Settings.scale, Settings.CREAM_COLOR);
        this.masterSlider.render(sb);
        this.bgmSlider.render(sb);
        this.sfxSlider.render(sb);
        this.ambienceToggle.render(sb);
    }

    private void renderPreferences(SpriteBatch sb) {
        FontHelper.renderFontCentered(sb, FontHelper.deckBannerFont, TEXT[8], 636.0f * Settings.scale, Settings.OPTION_Y - 66.0f * Settings.scale, Settings.GOLD_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[9], 456.0f * Settings.scale, Settings.OPTION_Y + -112.0f * Settings.scale, 10000.0f, 34.0f * Settings.scale, Settings.CREAM_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[10], 456.0f * Settings.scale, Settings.OPTION_Y + -246.0f * Settings.scale, 10000.0f, 34.0f * Settings.scale, Settings.CREAM_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[11], 686.0f * Settings.scale, Settings.OPTION_Y + -246.0f * Settings.scale, 10000.0f, 34.0f * Settings.scale, Settings.CREAM_COLOR);
        this.sumToggle.render(sb);
        this.blockToggle.render(sb);
        this.confirmToggle.render(sb);
        this.commonToggle.render(sb);
        this.cardToggle.render(sb);
        this.powerToggle.render(sb);
        this.relicToggle.render(sb);
    }

    private void renderMiscellaneous(SpriteBatch sb) {
        FontHelper.renderFontCentered(sb, FontHelper.deckBannerFont, TEXT[12], 1264.0f * Settings.scale, Settings.OPTION_Y - 66.0f * Settings.scale, Settings.GOLD_COLOR);
        FontHelper.renderSmartText(sb, FontHelper.rewardTipFont, TEXT[13], 1020.0f * Settings.scale, Settings.OPTION_Y + -150.0f * Settings.scale, 10000.0f, 44.0f * Settings.scale, Settings.CREAM_COLOR);
        if (Settings.isBeta) {
            FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[18], 1056.0f * Settings.scale, Settings.OPTION_Y + -212.0f * Settings.scale, 10000.0f, 34.0f * Settings.scale, Settings.CREAM_COLOR);
        }
        FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, TEXT[14], 1056.0f * Settings.scale, Settings.OPTION_Y + -248.0f * Settings.scale, 10000.0f, 34.0f * Settings.scale, Settings.CREAM_COLOR);
        this.uploadToggle.render(sb);
        this.languageDropdown.render(sb);
        this.uploadQuestionHb.render(sb);
        if (Settings.isBeta) {
            this.playtesterToggle.render(sb);
        }
    }

    public void refresh() {
        this.fsToggle = new ToggleButton(TOGGLE_X_LEFT, 98.0f, ToggleButton.ToggleBtnType.FULL_SCREEN);
        this.wfsToggle = new ToggleButton(TOGGLE_X_LEFT, 64.0f, ToggleButton.ToggleBtnType.W_FULL_SCREEN);
        this.ssToggle = new ToggleButton(TOGGLE_X_LEFT, 30.0f, ToggleButton.ToggleBtnType.SCREEN_SHAKE);
        this.vSyncToggle = new ToggleButton(TOGGLE_X_LEFT_2, 30.0f, ToggleButton.ToggleBtnType.V_SYNC);
        this.sumToggle = new ToggleButton(TOGGLE_X_LEFT, -122.0f, ToggleButton.ToggleBtnType.SUM_DMG);
        this.blockToggle = new ToggleButton(TOGGLE_X_LEFT, -156.0f, ToggleButton.ToggleBtnType.BLOCK_DMG);
        this.confirmToggle = new ToggleButton(TOGGLE_X_LEFT, -190.0f, ToggleButton.ToggleBtnType.HAND_CONF);
        this.commonToggle = new ToggleButton(TOGGLE_X_LEFT, -254.0f, ToggleButton.ToggleBtnType.COMMON_TIP);
        this.cardToggle = new ToggleButton(TOGGLE_X_LEFT, -288.0f, ToggleButton.ToggleBtnType.CARD_TIP);
        this.powerToggle = new ToggleButton(TOGGLE_X_LEFT_2, -254.0f, ToggleButton.ToggleBtnType.POWER_TIP);
        this.relicToggle = new ToggleButton(TOGGLE_X_LEFT_2, -288.0f, ToggleButton.ToggleBtnType.RELIC_TIP);
        this.ambienceToggle = new ToggleButton(TOGGLE_X_RIGHT, 34.0f, ToggleButton.ToggleBtnType.AMBIENCE_ON);
        if (Settings.isBeta) {
            this.playtesterToggle = new ToggleButton(TOGGLE_X_RIGHT, -220.0f, ToggleButton.ToggleBtnType.PLAYTESTER_ART);
        }
        this.uploadToggle = new ToggleButton(TOGGLE_X_RIGHT, -254.0f, ToggleButton.ToggleBtnType.UPLOAD_DATA);
        this.masterSlider = new Slider(Settings.OPTION_Y + 186.0f * Settings.scale, Settings.MASTER_VOLUME, Slider.SliderType.MASTER);
        this.bgmSlider = new Slider(Settings.OPTION_Y + 142.0f * Settings.scale, Settings.MUSIC_VOLUME, Slider.SliderType.BGM);
        this.sfxSlider = new Slider(Settings.OPTION_Y + 98.0f * Settings.scale, Settings.SOUND_VOLUME, Slider.SliderType.SFX);
        this.resoDropdown = new Dropdown(670.0f * Settings.scale, 196.0f, Dropdown.DropdownType.RESOLUTION);
        this.fpsDropdown = new Dropdown(670.0f * Settings.scale, 160.0f, Dropdown.DropdownType.FPS);
        this.languageDropdown = new Dropdown(1300.0f * Settings.scale, -154.0f, Dropdown.DropdownType.LANGUAGE);
        if (Settings.isDailyRun) {
            this.exitBtn.updateLabel(TEXT[15]);
        } else {
            this.exitBtn.updateLabel(TEXT[16]);
            switch (AbstractDungeon.player.chosenClass) {
                case IRONCLAD: {
                    if (Gdx.files.local(SaveAndContinue.IRONCLAD_FILE).exists()) break;
                    this.exitBtn.updateLabel(TEXT[15]);
                    break;
                }
                case THE_SILENT: {
                    if (Gdx.files.local(SaveAndContinue.THE_SILENT_FILE).exists()) break;
                    this.exitBtn.updateLabel(TEXT[15]);
                    break;
                }
                case CROWBOT: {
                    if (Gdx.files.local(SaveAndContinue.CROWBOT_FILE).exists()) break;
                    this.exitBtn.updateLabel(TEXT[15]);
                    break;
                }
                default: {
                    System.out.print(AbstractDungeon.player.chosenClass.toString() + " NOT FOUND IN CONFIRMPOPUP()");
                }
            }
        }
    }

    public static void writeDisplayConfigFile(int w, int h, int fps, boolean fs, boolean wfs, boolean vs) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter("info.displayconfig", "UTF-8");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        writer.println(Integer.toString(w));
        writer.println(Integer.toString(h));
        writer.println(Integer.toString(fps));
        writer.println(Boolean.toString(fs));
        writer.println(Boolean.toString(wfs));
        writer.println(Boolean.toString(vs));
        writer.close();
    }
}

